unit CoreClassesUnit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Product = class;
  [UmlElement('Package', Id='7ee4f56c-80df-4ee9-bb8c-3cbc4adfa332')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Product))]
  CoreClasses = class
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(CoreClasses))]
  [UmlCollection(TypeOf(Product))]
  IProductList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Product;
    procedure set_Item(index: Integer; Value: Product);
    property Item[index: Integer]: Product read get_Item write set_Item; default;
    function Add(value: Product): Integer;
    function Contains(value: Product): Boolean;
    function IndexOf(value: Product): Integer;
    procedure Insert(index: Integer; value: Product);
    procedure Remove(value: Product);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  [UmlElement(Id='6a0a0bc6-ffb6-40ea-a32e-8ff54bec862a')]
  Product = class(System.Object, ILoopBack)
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 1);
    const
      Name = Eco_FirstMember;
    end;

    ProductListAdapter = class(ObjectListAdapter, IProductList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Product;
      procedure set_Item(index: Integer; Value: Product);
      property Item[index: Integer]: Product read get_Item write set_Item; default;
      function Add(value: Product): Integer;
      function Contains(value: Product): Boolean;
      function IndexOf(value: Product): Integer;
      procedure Insert(index: Integer; value: Product);
      procedure Remove(value: Product);
    end;
  protected
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
    {$REGION 'Autogenerated ECO code'}
  public
    constructor Create(content: IContent); overload;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    
    
    function get_Name: string;
    procedure set_Name(Value: string);
    [UmlElement(Id='33f1c418-7a05-4ecf-a1e7-dbd63f21ca58', Index=Eco_LoopbackIndices.Name)]
    property Name: string read get_Name write set_Name;
    function AsIObject: IObjectInstance;
  strict protected
    eco_Content: IContent;
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
  strict private
    {$ENDREGION}
  public
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

constructor Product.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

function Product.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Product.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Product.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

procedure Product.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;
{$ENDREGION}

constructor Product.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

constructor Product.ProductListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Product.ProductListAdapter.get_Item(index: Integer): Product;
begin
  Result := (Product(inherited Adaptee[index]));
end;

procedure Product.ProductListAdapter.set_Item(index: Integer; Value: Product);
begin
  inherited Adaptee[index] := value;
end;

function Product.ProductListAdapter.Add(value: Product): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Product.ProductListAdapter.Contains(value: Product): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Product.ProductListAdapter.IndexOf(value: Product): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Product.ProductListAdapter.Insert(index: Integer; value: Product);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Product.ProductListAdapter.Remove(value: Product);
begin
  Self.Adaptee.Remove(value);
end;

function Product.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Product.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;



function Product.get_Name: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
end;

procedure Product.set_Name(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, (System.Object(Value)));
end;























end.
